//
//  SQLite.h
//  1Password
//
//  Created by Roustem Karimov on 17/06/08.
//  ARC-ified by Roustem Karimov on 21/02/12.
//
//  Copyright 2008, 2012 AgileBits Inc. All rights reserved.
//

#import <Foundation/Foundation.h>
#import <OnePasswordCore/OnePasswordCore.h>

//replication of types from sqlite3.h
typedef long long int sqlite_int64;
typedef unsigned long long int sqlite_uint64;
typedef struct sqlite3_stmt sqlite3_stmt;

@class SQLiteStatement;

@interface SQLite : NSObject

@property (nonatomic, readonly) NSString *filepath;
@property (nonatomic, assign) BOOL debug;
@property (nonatomic, readonly) BOOL isOpen;

+ (void)useSingleThreadedMode;
+ (const char *)version;

- (id)initWithPath:(NSString *)filepath;
- (BOOL)openWithError:(NSError **)error;
- (BOOL)openReadOnlyWithError:(NSError **)error;
- (BOOL)open __attribute__((deprecated)); // Use openWithError: instead. -- Roo, 2015-04-28
- (void)close;

- (BOOL)exec:(const char *)sql error:(NSError **)error;
- (BOOL)exec:(const char *)sql;
- (SQLiteStatement *)prepare:(const char *)sql;

- (NSArray *)select:(const char *)sql applyBindings:(void (^)(SQLiteStatement *s))applyBindings objectForRow:(id (^)(SQLiteStatement *row))objectForRow;
- (BOOL)exists:(const char *)sql applyBindings:(void (^)(SQLiteStatement *s))applyBindings;
- (NSUInteger)selectInt64:(const char *)sql applyBindings:(void (^)(SQLiteStatement *s))applyBindings;
- (OPTimestamp)selectTimestamp:(const char *)sql applyBindings:(void (^)(SQLiteStatement *s))applyBindings;
- (BOOL)update:(const char *)sql error:(NSError **)error applyBindings:(void (^)(SQLiteStatement *s))applyBindings;


- (sqlite_int64)lastInsertRowID;

- (const char *)lastErrorMessage;
- (NSError *)lastError;

- (BOOL)autocommit;

- (void)beginTransaction;
- (void)commitTransaction;
- (void)rollbackTransaction;

- (void)clearStatementCache;

- (BOOL)backupToFileAtPath:(NSString *)backupFilePath;

@end


@interface SQLiteStatement : NSObject {
	sqlite3_stmt *_handle;
	BOOL _available;
	NSMutableDictionary *_columnsByName;
}

- (id)initWithHandle:(sqlite3_stmt *)handle;
- (void)reset;
- (void)reserve;
- (BOOL)available;
- (int)step;

- (void)bindId:(OPID)oid atIndex:(int)index;

- (void)bindNullAtIndex:(int)index;
- (void)bindInt64:(sqlite_int64)value atIndex:(int)index;
- (void)bindInteger:(NSInteger)value atIndex:(int)index;
- (void)bindInt:(int)value atIndex:(int)index;
- (void)bindText:(NSString *)value atIndex:(int)index;
- (void)bindChars:(const char *)value atIndex:(int)index;
- (void)bindTimestamp:(sqlite_uint64)value atIndex:(int)index;
- (void)bindDouble:(double)value atIndex:(int)index;
- (void)bindBlob:(NSData *)value atIndex:(int)index;
- (void)bindBool:(BOOL)value atIndex:(int)index;

- (OPID)cId:(int)index;
- (sqlite_int64)cInt64:(int)index;
- (int)cInt:(int)index;
- (double)cDouble:(int)index;
- (sqlite_uint64)cTimestamp:(int)index;
- (BOOL)cBool:(int)index;
- (NSString *)cText:(int)index;
- (NSData *)cBlob:(int)index;

- (NSDictionary *)columnsByName;
- (int)columnIndex:(const char*)columnName;

- (OPID)columnId:(const char *)columnName;
- (sqlite_int64)columnInt64:(const char *)columnName;
- (int)columnInt:(const char *)columnName;
- (double)columnDouble:(const char *)columnName;
- (sqlite_uint64)columnTimestamp:(const char *)columnName;
- (BOOL)columnBool:(const char *)columnName;
- (NSString *)columnText:(const char *)columnName;
- (NSData *)columnBlob:(const char *)columnName;

@end